import xbmc
from urllib.request import Request, urlopen
from urllib.parse import quote
from urllib.error import URLError

# Volume map: Maps /Volumes/X/ to the server's expected path
VOLUME_MAP = {
    "3": "/mnt/sda1/Movies3/",
    "4": "/mnt/sda1/Movies4/",
    "5": "/mnt/sda1/Movies5/",  # Adjust if needed
    "7": "/mnt/sda1/Movies7/",  # Update this to the correct path for Volume 7
    "8": "/mnt/sda1/Movies8/"
    # Add more volumes as needed, e.g., "8": "/mnt/sda1/Movies8/"
}

class MyPlayer(xbmc.Player):
    def __init__(self):
        xbmc.Player.__init__(self)
        xbmc.log("MyPlayer initialized", xbmc.LOGINFO)

    def onPlayBackStarted(self):
        xbmc.log("Playback started detected", xbmc.LOGINFO)
        
        xbmc.sleep(500)  # Wait for playback to stabilize
        
        try:
            file_path = self.getPlayingFile()
            xbmc.log(f"Original file path: {file_path}", xbmc.LOGINFO)
            
            # Normalize the path using the volume map
            normalized_path = file_path
            if file_path.startswith("/Volumes/"):
                volume_num = file_path.split("/")[2]
                if volume_num in VOLUME_MAP:
                    normalized_path = file_path.replace(f"/Volumes/{volume_num}/", VOLUME_MAP[volume_num])
                    xbmc.log(f"Normalized file path: {normalized_path}", xbmc.LOGINFO)
                else:
                    xbmc.log(f"Volume {volume_num} not found in VOLUME_MAP, skipping request", xbmc.LOGWARNING)
                    return
            else:
                xbmc.log("File path not under /Volumes/, using original path", xbmc.LOGINFO)
        except Exception as e:
            xbmc.log(f"Error getting or normalizing file: {e}", xbmc.LOGERROR)
            return

        json_payload = f'{{"path":"{normalized_path}","index":0,"type":1,"appDeviceType":2,"extraNetPath":"192.168.1.238/Storage/UHD/","playMode":0}}'
        encoded_payload = quote(json_payload)
        url = f"http://192.168.1.57:436/playnormalfile?{encoded_payload}"
        xbmc.log(f"Constructed URL: {url}", xbmc.LOGINFO)

        # Send the HTTP request with retries
        for attempt in range(2):
            try:
                req = Request(url)
                xbmc.log(f"Sending HTTP request (attempt {attempt + 1})", xbmc.LOGINFO)
                with urlopen(req) as response:
                    status_code = response.getcode()
                    response_content = response.read().decode('utf-8', errors='ignore')
                    xbmc.log(f"HTTP response: status code: {status_code}, content: {response_content}", xbmc.LOGINFO)
                    
                    if '"success":true' in response_content:
                        xbmc.log("Server confirmed successful playback", xbmc.LOGINFO)
                        break
                    else:
                        xbmc.log("Server rejected request (success:false)", xbmc.LOGWARNING)
                        if attempt == 0:
                            xbmc.log("Retrying after 2-second delay", xbmc.LOGINFO)
                            xbmc.sleep(2000)
                        else:
                            xbmc.log("Final retry failed", xbmc.LOGERROR)
            except URLError as e:
                xbmc.log(f"HTTP request failed: {e}", xbmc.LOGERROR)
                if attempt == 0:
                    xbmc.log("Retrying after 1-second delay", xbmc.LOGINFO)
                    xbmc.sleep(1000)
                else:
                    xbmc.log("Final retry failed due to network error", xbmc.LOGERROR)

        self.stop()
        xbmc.executebuiltin("Action(Stop)")

class MyMonitor(xbmc.Monitor):
    def __init__(self, player):
        self.player = player
        xbmc.log("MyMonitor initialized", xbmc.LOGINFO)

    def onAbortRequested(self):
        xbmc.log("Abort requested", xbmc.LOGINFO)

player = MyPlayer()
monitor = MyMonitor(player)

xbmc.log("Script started, entering main loop", xbmc.LOGINFO)
while not monitor.abortRequested():
    if player.isPlaying():
        xbmc.log("Player is active", xbmc.LOGINFO)
        xbmc.sleep(1000)
    else:
        xbmc.log("Player is idle", xbmc.LOGDEBUG)
        monitor.waitForAbort(1)